## ------------------------------------------------------------------------

library(openxlsx)
library(dplyr)
library(stargazer)
library(spatstat)
library(rgeos)
library(pastecs)
library(car)


## ------------------------------------------------------------------------
# I like to read in the data into a dataframe called "d" so there is less typing...

d<-read.xlsx("Activity_Space_Data.xlsx")

# some basic recodes

d<-rename(d,respid=Respid)

d<-rename(d,age=Age)
d$age<-as.numeric(d$age)

d<-rename(d,female=Gender)
d$female<-as.numeric(d$female)

# tablet or paper mode
d$tablet<-as.integer(d$Intrw_type==1)

# health as collected was 1-5, with 1=Excellent, 5=Poor
# reverse code this
d$health<-6-as.numeric(d$D9)

# education is years, 0-19.  We observe 0 to 16 in our data.
d$educ<-as.numeric(d$A2)

d$married<-as.numeric(d$A8)

# occupation of respondent.
d$nonfarmjob<-ifelse(d$B1 %in% c("1","2","3","4"), 1,0)

# how difficult was it for respondent to follow mapping protocol, as percevied by interviewer
d$difficulty<-ifelse(d$tablet==1, as.integer(d$F8), as.integer(d$F9))
d$difficulty<-ifelse(d$difficulty==99, NA, d$difficulty)

d<-left_join(d, respondentErrordf, by="respid")

# ------------------
# models in table 2

model1<-lm(meanError ~ tablet, data=d)

model2<-lm(meanError ~ tablet + age + educ + female + health + difficulty, data=d)

model3<-lm(meanError ~ tablet + age + age*tablet + educ + educ*tablet + female + female*tablet +
         health + health*tablet + difficulty + difficulty*tablet, data=d)

stargazer(model1, model2, model3, type="text")


## ------------------------------------------------------------------------
options(scipen=100)
#options(digits=2)
stat.desc(d[!is.na(d$meanError),c("meanError","tablet","age","educ","female","health","difficulty")])
stargazer(d[!is.na(d$meanError),c("meanError","tablet","age","educ","female","health","difficulty")], type="text", digits=2)

stargazer(d[!is.na(d$meanError) & d$tablet==1,c("meanError","tablet","age","educ","female","health","difficulty")], type="text", digits=2)
stargazer(d[!is.na(d$meanError) & d$tablet==0,c("meanError","tablet","age","educ","female","health","difficulty")], type="text", digits=2)



## ------------------------------------------------------------------------
d$ageGroup<-recode(d$age, "15:19=1; 20:29=2; 30:39=3; 40:50=4")
table(d[!is.na(d$meanError),"ageGroup"])
table(d[!is.na(d$meanError) & d$tablet==1,"ageGroup"])
table(d[!is.na(d$meanError) & d$tablet==0,"ageGroup"])
describe(d[!is.na(d$meanError) & d$tablet==1,"ageGroup"])
describe(d[!is.na(d$meanError) & d$tablet==0,"ageGroup"])

d$educGroup<-recode(d$educ, "0:6=1; 7:9=2; 10:12=3; 14:16=4")
table(d[!is.na(d$meanError),"educGroup"])
table(d[!is.na(d$meanError) & d$tablet==1,"educGroup"])
table(d[!is.na(d$meanError) & d$tablet==0,"educGroup"])
describe(d[!is.na(d$meanError) & d$tablet==1,"educGroup"])
describe(d[!is.na(d$meanError) & d$tablet==0,"educGroup"])

table(d[!is.na(d$meanError),"health"])
table(d[!is.na(d$meanError) & d$tablet==1,"health"])
table(d[!is.na(d$meanError) & d$tablet==0,"health"])
describe(d[!is.na(d$meanError) & d$tablet==1,"health"])
describe(d[!is.na(d$meanError) & d$tablet==0,"health"])




## ------------------------------------------------------------------------
table(d[!is.na(d$meanError),"ageGroup"])
describe(d[!is.na(d$meanError),"ageGroup"])

table(d[!is.na(d$meanError),"educGroup"])
describe(d[!is.na(d$meanError),"educGroup"])

table(d[!is.na(d$meanError),"health"])
describe(d[!is.na(d$meanError),"health"])


## ------------------------------------------------------------------------
t.test(d[!is.na(d$meanError),"difficulty"]~d[!is.na(d$meanError),"tablet"])
t.test(d$meanError~d$tablet)

## ------------------------------------------------------------------------
t.test(d[!is.na(d$meanError),"age"]~d[!is.na(d$meanError),"tablet"])
t.test(d[!is.na(d$meanError),"educ"]~d[!is.na(d$meanError),"tablet"])
t.test(d[!is.na(d$meanError),"female"]~d[!is.na(d$meanError),"tablet"])
t.test(d[!is.na(d$meanError),"health"]~d[!is.na(d$meanError),"tablet"])
t.test(d[!is.na(d$meanError),"difficulty"]~d[!is.na(d$meanError),"tablet"])

